/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_04;
import lotus.domino.*;

import java.awt.*;
import java.awt.event.*;
import java.net.URLDecoder;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class AppletAwtEvent extends AppletBase implements ActionListener {
 
	private Graphics graphics;
	private Label user;
	private Label localInfo;
	private Label serverInfo;
	private Button button;
	private String text = "";
	private String server = "";
	private Session session;
	private int startedCount = 0;
	private int stoppedCount = 0;
	
	public void notesAppletInit() {
		graphics = getGraphics();
		button = new Button("Aktuellen Benutzer anzeigen:");
		user = new Label ("Bitte Button klicken");
		localInfo = new Label ("");
		serverInfo = new Label ("");
		add(button);
		add (user);
		add (localInfo);
		add (serverInfo);
		setVisible(true);
		try {
			if (isNotesLocal()) {
				session = this.getSession ();
			} else {
				session = this.getSession("", "");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void notesAppletStart() {
		startedCount++;
		button.addActionListener(this);
		user.setText("started " + startedCount + "/" + stoppedCount);		
	}

	public void notesAppletStop () {
		stoppedCount++;
	}
	public void notesAppletDestroy() {
		/* Hinweis: Bei einer remote Session (Applet im Browser) 
		 * wird die session in AppletBase nur abgebaut, wenn sie im notesAppletDestroy 
		 * geschlossen wird.
		 * Daher sollte sie auch nur im notesAppletInit geffnet werden.
		 */
		try {
			this.closeSession(session);
		} catch (NotesException e) {
			e.printStackTrace();
		}
		super.destroy();
	}
	
	public void actionPerformed(ActionEvent e) {
		try {
			if (isNotesLocal()) {
				NotesThread.sinitThread();
			} 
			NotesAppletContext nac=null;
			try {
				nac = getContext(session);
			} catch (NotesException ne) {
				//ignore - Diese Exception tritt nur auf, falls ber IDE gestartet.
				//der Applet Context kann nur ber Domino (Client oder Browser) 
				//bezogen werden.
			}
			server = (nac!=null?URLDecoder.decode(nac.getServer())
					+ "!!" + nac.getDatabase().getFilePath():"");
			text = "Benutzer: " + session.getCommonUserName();
		} catch (NotesException e1) {
			text = e1.id + " " + e1.text;
		} catch (Exception e1) {
			e1.printStackTrace();
		} finally {
			if (isNotesLocal()) {
				NotesThread.stermThread();
			}
		}
		serverInfo.setText (server);
		localInfo.setText("AWT (Event) Example: " + (isNotesLocal()?"Lokal":"Remote"));
		user.setText(text);
	}
	
	public void paint(Graphics g) {
		button.setLocation(0, 0);
		localInfo.setLocation(0,20);
		localInfo.setSize(200,50);
		serverInfo.setLocation(0,50);
		serverInfo.setSize(200,50);
		user.setLocation(0,80);
		user.setSize(200,50);
	}
}